/*
 * PropertyList.java
 *
 * Created on March 3, 2003, 11:40 AM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.utils;

/**
 * A simple property-value access mechanism.
 * @author  danny brewer
 */
public interface PropertyList {
	
	public Object getProperty( String propName );
	public void setProperty( String propName, Object value );
	
	public int getIntProperty( String propName );
	public int getIntProperty( String propName, int defaultValue );
	public void setIntProperty( String propName, int value );
	
	public long getLongProperty( String propName );
	public long getLongProperty( String propName, long defaultValue );
	public void setLongProperty( String propName, long value );
	
	public String getStringProperty( String propName );
	public String getStringProperty( String propName, String defaultValue );
	public void setStringProperty( String propName, String value );
	
	public boolean getBooleanProperty( String propName );
	public boolean getBooleanProperty( String propName, boolean defaultValue );
	public void setBooleanProperty( String propName, boolean value );
	
	public float getFloatProperty( String propName );
	public float getFloatProperty( String propName, float defaultValue );
	public void setFloatProperty( String propName, float value );
	
	public double getDoubleProperty( String propName );
	public double getDoubleProperty( String propName, double defaultValue );
	public void setDoubleProperty( String propName, double value );
	
}
